import { OutputProcess } from '@shopify/cli-kit/node/output';
import { FunctionComponent } from 'react';
import { AbortController } from '@shopify/cli-kit/node/abort';
export interface DeveloperPreviewController {
    fetchMode: () => Promise<boolean>;
    enable: () => Promise<void>;
    disable: () => Promise<void>;
    update: (state: boolean) => Promise<boolean>;
}
export interface DevProps {
    processes: OutputProcess[];
    abortController: AbortController;
    previewUrl: string;
    graphiqlUrl?: string;
    graphiqlPort: number;
    app: {
        canEnablePreviewMode: boolean;
        developmentStorePreviewEnabled?: boolean;
        apiKey: string;
        token: string;
    };
    pollingTime?: number;
    developerPreview: DeveloperPreviewController;
    isEditionWeek?: boolean;
}
declare const Dev: FunctionComponent<DevProps>;
export { Dev };
