/// <reference types="node" resolution-mode="require"/>
import { ExtensionInstance } from '../../models/extensions/extension-instance.js';
import { Writable } from 'stream';
interface UpdateExtensionDraftOptions {
    extension: ExtensionInstance;
    token: string;
    apiKey: string;
    registrationId: string;
    stdout: Writable;
    stderr: Writable;
}
export declare function updateExtensionDraft({ extension, token, apiKey, registrationId, stdout, stderr, }: UpdateExtensionDraftOptions): Promise<void>;
interface UpdateExtensionConfigOptions {
    extension: ExtensionInstance;
    stdout: Writable;
}
export declare function reloadExtensionConfig({ extension }: UpdateExtensionConfigOptions): Promise<{
    previousConfig: {
        name: string;
        type: string;
        metafields: {
            namespace: string;
            key: string;
        }[];
        handle?: string | undefined;
        description?: string | undefined;
        api_version?: string | undefined;
        extension_points?: any;
        capabilities?: {
            network_access?: boolean | undefined;
            block_progress?: boolean | undefined;
            api_access?: boolean | undefined;
            collect_buyer_consent?: {
                sms_marketing?: boolean | undefined;
                customer_privacy?: boolean | undefined;
            } | undefined;
        } | undefined;
        settings?: {
            fields?: {
                type: string;
                key?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                required?: boolean | undefined;
                validations?: any[] | undefined;
            }[] | undefined;
        } | undefined;
    };
    newConfig: {
        name: string;
        type: string;
        metafields: {
            namespace: string;
            key: string;
        }[];
        handle?: string | undefined;
        description?: string | undefined;
        api_version?: string | undefined;
        extension_points?: any;
        capabilities?: {
            network_access?: boolean | undefined;
            block_progress?: boolean | undefined;
            api_access?: boolean | undefined;
            collect_buyer_consent?: {
                sms_marketing?: boolean | undefined;
                customer_privacy?: boolean | undefined;
            } | undefined;
        } | undefined;
        settings?: {
            fields?: {
                type: string;
                key?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                required?: boolean | undefined;
                validations?: any[] | undefined;
            }[] | undefined;
        } | undefined;
    };
}>;
export {};
