import { LocalStorage } from '@shopify/cli-kit/node/local-storage';
import { outputDebug, outputContent, outputToken } from '@shopify/cli-kit/node/output';
import { normalizePath } from '@shopify/cli-kit/node/path';
let _appLocalStorageInstance;
function appLocalStorage() {
    if (!_appLocalStorageInstance) {
        _appLocalStorageInstance = new LocalStorage({ projectName: 'shopify-cli-app' });
    }
    return _appLocalStorageInstance;
}
export function getCachedAppInfo(directory, config = appLocalStorage()) {
    const normalized = normalizePath(directory);
    outputDebug(outputContent `Reading cached app information for directory ${outputToken.path(normalized)}...`);
    return config.get(normalized);
}
export function clearCachedAppInfo(directory, config = appLocalStorage()) {
    const normalized = normalizePath(directory);
    outputDebug(outputContent `Clearing app information for directory ${outputToken.path(normalized)}...`);
    config.delete(normalized);
}
export function setCachedAppInfo(options, config = appLocalStorage()) {
    options.directory = normalizePath(options.directory);
    outputDebug(outputContent `Storing app information for directory ${outputToken.path(options.directory)}:${outputToken.json(options)}`);
    const savedApp = config.get(options.directory);
    if (savedApp) {
        config.set(options.directory, {
            ...savedApp,
            ...options,
        });
    }
    else {
        config.set(options.directory, options);
    }
}
export function clearCurrentConfigFile(directory, config = appLocalStorage()) {
    const normalized = normalizePath(directory);
    const savedApp = config.get(normalized);
    config.set(normalized, {
        ...savedApp,
        configFile: undefined,
    });
}
let _commandLocalStorageInstance;
function commandLocalStorage() {
    if (!_commandLocalStorageInstance) {
        _commandLocalStorageInstance = new LocalStorage({ projectName: 'shopify-cli-app-command' });
    }
    return _commandLocalStorageInstance;
}
export function setCachedCommandInfo(data) {
    const id = process.env.COMMAND_RUN_ID;
    if (!id)
        return;
    const store = commandLocalStorage();
    const info = store.get(id);
    store.set(id, {
        ...info,
        ...data,
    });
}
export function getCachedCommandInfo() {
    const id = process.env.COMMAND_RUN_ID;
    if (!id)
        return;
    const store = commandLocalStorage();
    return store.get(id);
}
export function clearCachedCommandInfo() {
    const store = commandLocalStorage();
    store.clear();
}
//# sourceMappingURL=local-storage.js.map