import { SelectInput } from './SelectInput.js';
import { PromptLayout } from './Prompts/PromptLayout.js';
import usePrompt, { PromptState } from '../hooks/use-prompt.js';
import React, { useCallback, useEffect } from 'react';
import { useApp } from 'ink';
// eslint-disable-next-line react/function-component-definition
function SelectPrompt({ message, choices, infoTable, infoMessage, gitDiff, onSubmit, defaultValue, abortSignal, }) {
    if (choices.length === 0) {
        throw new Error('SelectPrompt requires at least one choice');
    }
    const { exit: unmountInk } = useApp();
    const { promptState, setPromptState, answer, setAnswer } = usePrompt({
        initialAnswer: undefined,
    });
    const submitAnswer = useCallback((answer) => {
        setAnswer(answer);
        setPromptState(PromptState.Submitted);
    }, [setAnswer, setPromptState]);
    useEffect(() => {
        if (promptState === PromptState.Submitted && answer) {
            unmountInk();
            onSubmit(answer.value);
        }
    }, [answer, onSubmit, promptState, unmountInk]);
    return (React.createElement(PromptLayout, { message: message, state: promptState, submittedAnswerLabel: answer?.label, infoTable: infoTable, infoMessage: infoMessage, gitDiff: gitDiff, abortSignal: abortSignal, input: React.createElement(SelectInput, { defaultValue: defaultValue, items: choices, onSubmit: submitAnswer }) }));
}
export { SelectPrompt };
//# sourceMappingURL=SelectPrompt.js.map