import { unionArrayStrategy } from '../../private/common/array.js';
import deepMerge from 'deepmerge';
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
/**
 * Deep merges the two objects and returns a new object with the merge result.
 *
 * @param lhs - One of the objects to be merged.
 * @param rhs - Another object to be merged.
 * @param arrayMergeStrategy - Strategy used to merge the array typed fields. Union strategy is used by default to avoid
 * duplicated elements.
 * @returns A Javascrip tobject with th emerged objects.
 */
export function deepMergeObjects(lhs, rhs, arrayMergeStrategy = unionArrayStrategy) {
    return deepMerge(lhs, rhs, { arrayMerge: arrayMergeStrategy });
}
/**
 * Creates an object composed of the `object` properties `predicate` returns
 * truthy for. The predicate is invoked with two arguments: (value, key).
 *
 * @param object - The source object.
 * @param predicate - The function invoked per property.
 * @returns Returns the new object.
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
export function pickBy(object, predicate) {
    const lodashPickBy = require('lodash/pickBy.js');
    return lodashPickBy(object, predicate);
}
/**
 * Creates an object with the same keys as object and values generated by running each own
 * enumerable property of object through iteratee. The iteratee function is
 * invoked with three arguments: (value, key, object).
 *
 * @param source - The object to iterate over.
 * @param callback - The function invoked per iteration.
 * @returns Returns the new mapped object.
 */
export function mapValues(source, callback) {
    const lodashMapValues = require('lodash/mapValues.js');
    return lodashMapValues(source, callback);
}
/**
 * Deeply compares two objects and returns true if they are equal.
 *
 * @param one - The first object to be compared.
 * @param two - The second object to be compared.
 * @returns True if the objects are equal, false otherwise.
 */
export function deepCompare(one, two) {
    const lodashIsEqual = require('lodash/isEqual.js');
    return lodashIsEqual(one, two);
}
/**
 * Return the difference between two nested objects.
 *
 * @param one - The first object to be compared.
 * @param two - The second object to be compared.
 * @returns Two objects containing the fields that are different, each one with the values of one object.
 */
export function deepDifference(one, two) {
    const differenceWith = require('lodash/differenceWith.js');
    const fromPairs = require('lodash/fromPairs.js');
    const toPairs = require('lodash/toPairs.js');
    const changes = differenceWith(toPairs(one), toPairs(two), deepCompare);
    const changes2 = differenceWith(toPairs(two), toPairs(one), deepCompare);
    return [fromPairs(changes), fromPairs(changes2)];
}
/**
 * Gets the value at path of object. If the resolved value is undefined, the defaultValue is returned in its place.
 *
 * @param object - The object to query.
 * @param path - The path of the property to get.
 * @returns - Returns the resolved value.
 */
export function getPathValue(object, path) {
    const get = require('lodash/get.js');
    return get(object, path) === undefined ? undefined : get(object, path);
}
/**
 * Sets the value at path of object. If a portion of path doesn't exist, it's create.
 *
 * @param object - The object to modify.
 * @param path - The path of the property to set.
 * @param value - The value to set.
 * @returns - Returns object.
 */
export function setPathValue(object, path, value) {
    const set = require('lodash/set.js');
    return set(object, path, value);
}
/**
 * Checks if value is an empty object, collection, map, or set.
 *
 * @param object - The value to check.
 * @returns - Returns true if value is empty, else false.
 */
export function isEmpty(object) {
    const isEmpty = require('lodash/isEmpty.js');
    return isEmpty(object);
}
//# sourceMappingURL=object.js.map