/// <reference types="node" resolution-mode="require"/>
import { AbortSignal } from './abort.js';
import { Writable } from 'stream';
export declare const RubyCLIVersion = "2.35.0";
export declare const MinWdmWindowsVersion = "0.1.0";
interface ExecCLI2Options {
    store?: string;
    adminToken?: string;
    storefrontToken?: string;
    token?: string;
    directory?: string;
    signal?: AbortSignal;
    stdout?: Writable;
    stderr?: Writable;
}
/**
 * Execute CLI 2.0 commands.
 * Installs a version of RubyCLI as a vendor dependency in a hidden folder in the system.
 * User must have a valid ruby+bundler environment to run any command.
 *
 * @param args - List of argumets to execute. (ex: ['theme', 'pull']).
 * @param options - Options to customize the execution of cli2.
 */
export declare function execCLI2(args: string[], options?: ExecCLI2Options): Promise<void>;
/**
 * It returns the Ruby version present in the envirronment.
 */
export declare function version(): Promise<string | undefined>;
/**
 * It returns a custom BUNDLE_USER_HOME. This is required in Windows because
 * bundler will instead crash if the username contains UTF-8 characters.
 *
 * @returns The value of the environment variable.
 */
export declare function bundleUserHome(): string | undefined;
export {};
