import { ZodTypeAny, z } from 'zod';
export { z as zod } from 'zod';
/**
 * Returns a new schema that is the same as the input schema, but with all nested schemas set to strict.
 *
 * @param schema - The schema to make strict.
 * @returns The result strict schema.
 */
export declare function deepStrict(schema: ZodTypeAny): ZodTypeAny;
/**
 * Returns a human-readable string of the list of zod errors.
 *
 * @param errors - The list of zod errors.
 * @returns The human-readable string.
 */
export declare function errorsToString(errors: z.ZodIssueBase[]): string;
