import { AdminSession } from '@shopify/cli-kit/node/session';
import { BulkUploadResult, Checksum, Key, Theme, ThemeAsset } from '@shopify/cli-kit/node/themes/types';
export type ThemeParams = Partial<Pick<Theme, 'name' | 'role' | 'processing'>>;
export type AssetParams = Partial<Pick<ThemeAsset, 'key' | 'value'>>;
export declare function fetchTheme(id: number, session: AdminSession): Promise<Theme | undefined>;
export declare function fetchThemes(session: AdminSession): Promise<Theme[]>;
export declare function createTheme(params: ThemeParams, session: AdminSession): Promise<Theme | undefined>;
export declare function fetchThemeAsset(id: number, key: Key, session: AdminSession): Promise<ThemeAsset | undefined>;
export declare function deleteThemeAsset(id: number, key: Key, session: AdminSession): Promise<boolean>;
export declare function bulkUploadThemeAssets(id: number, assets: AssetParams[], session: AdminSession): Promise<BulkUploadResult[]>;
export declare function fetchChecksums(id: number, session: AdminSession): Promise<Checksum[]>;
interface UpgradeThemeOptions {
    fromTheme: number;
    toTheme: number;
    script?: string;
    session: AdminSession;
}
export declare function upgradeTheme(upgradeOptions: UpgradeThemeOptions): Promise<Theme | undefined>;
export declare function updateTheme(id: number, params: ThemeParams, session: AdminSession): Promise<Theme | undefined>;
export declare function publishTheme(id: number, session: AdminSession): Promise<Theme | undefined>;
export declare function deleteTheme(id: number, session: AdminSession): Promise<Theme | undefined>;
export {};
