import { BulkUploadResult, Checksum, Theme, ThemeAsset } from '@shopify/cli-kit/node/themes/types';
interface RemoteThemeResponse {
    id: number;
    name: string;
    role: string;
    createdAtRuntime?: boolean;
    processing?: boolean;
}
interface RemoteAssetResponse {
    key: string;
    checksum: string;
    attachment: string;
    value: string;
}
interface RemoteBulkUploadResponse {
    body: {
        asset: RemoteAssetResponse;
    };
    code: number;
    errors?: string[];
}
export declare function buildTheme(themeJson?: RemoteThemeResponse): Theme | undefined;
export declare function buildChecksum(asset?: RemoteAssetResponse): Checksum | undefined;
export declare function buildThemeAsset(asset?: RemoteAssetResponse): ThemeAsset | undefined;
export declare function buildBulkUploadResults(bulkUpload?: RemoteBulkUploadResponse): BulkUploadResult | undefined;
export {};
