export function buildTheme(themeJson) {
    if (!themeJson)
        return;
    themeJson.processing ?? (themeJson.processing = false);
    themeJson.createdAtRuntime ?? (themeJson.createdAtRuntime = false);
    const { id, name, role, processing, createdAtRuntime } = themeJson;
    return {
        id,
        name,
        processing,
        createdAtRuntime,
        role: role === 'main' ? 'live' : role,
    };
}
export function buildChecksum(asset) {
    if (!asset)
        return;
    const { key, checksum } = asset;
    return { key, checksum };
}
export function buildThemeAsset(asset) {
    if (!asset)
        return;
    const { key, checksum, attachment, value } = asset;
    return { key, checksum, attachment, value };
}
export function buildBulkUploadResults(bulkUpload) {
    if (!bulkUpload)
        return;
    return {
        key: bulkUpload.body.asset.key,
        success: bulkUpload.code === 200,
        errors: bulkUpload.errors || [],
        asset: bulkUpload.body.asset || {},
    };
}
//# sourceMappingURL=factories.js.map