type AfterKillCallback = (error?: Error) => void;
/**
 * Kills the process that calls the method and all its children.
 *
 * @param pid - Pid of the process to kill.
 * @param killSignal - Type of kill signal to be used.
 * @param killRoot - Whether to kill the root process.
 * @param callback - Optional callback to run after killing the processes.
 */
export declare function treeKill(pid?: number | string, killSignal?: string, killRoot?: boolean, callback?: AfterKillCallback): void;
export {};
