import { BaseOtelService } from '../BaseOtelService/BaseOtelService.js';
import type { BaseOtelServiceOptions } from '../BaseOtelService/BaseOtelService.js';
export interface DefaultOtelServiceOptions extends BaseOtelServiceOptions {
    /**
     * What environment is being deployed (production, staging)
     */
    env?: string;
    /**
     * How much the export should be throttled in milliseconds.
     */
    throttleLimit?: number;
    /**
     * Determines whether to send metrics via XHR or beacon. Defaults to false.
     */
    useXhr?: boolean;
    otelEndpoint: string;
}
export declare class DefaultOtelService extends BaseOtelService {
    /**
     * Bootstraps an Otel exporter which can send Otel metrics to a dedicated Shopify supported collector endpoint.
     */
    constructor({ throttleLimit, env, serviceName, prefixMetric, metrics, onRecord, meterProvider, useXhr, otelEndpoint, }: DefaultOtelServiceOptions);
    shutdown(): Promise<void>;
}
