"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dropLast = exports.deepGet = exports.locEnd = exports.locStart = exports.assertNever = void 0;
function assertNever(x) {
    throw new Error(`Unexpected object: ${x.type}`);
}
exports.assertNever = assertNever;
function locStart(node) {
    return node.position.start;
}
exports.locStart = locStart;
function locEnd(node) {
    return node.position.end;
}
exports.locEnd = locEnd;
function deepGet(path, obj) {
    return path.reduce((curr, k) => {
        if (curr && curr[k] !== undefined)
            return curr[k];
        return undefined;
    }, obj);
}
exports.deepGet = deepGet;
function dropLast(n, xs) {
    const result = [...xs];
    for (let i = 0; i < n; i++) {
        result.pop();
    }
    return result;
}
exports.dropLast = dropLast;
//# sourceMappingURL=utils.js.map