import type { MetaTokenProperties } from '../types';
export type ColorBackgroundAlias = 'bg-fill-active' | 'bg-fill-brand-active' | 'bg-fill-brand-disabled' | 'bg-fill-brand-hover' | 'bg-fill-brand-selected' | 'bg-fill-brand' | 'bg-fill-caution-active' | 'bg-fill-caution-hover' | 'bg-fill-caution-secondary' | 'bg-fill-caution' | 'bg-fill-critical-active' | 'bg-fill-critical-hover' | 'bg-fill-critical-secondary' | 'bg-fill-critical-selected' | 'bg-fill-critical' | 'bg-fill-disabled' | 'bg-fill-emphasis-active' | 'bg-fill-emphasis-hover' | 'bg-fill-emphasis' | 'bg-fill-hover' | 'bg-fill-info-active' | 'bg-fill-info-hover' | 'bg-fill-info-secondary' | 'bg-fill-info' | 'bg-fill-inverse-active' | 'bg-fill-inverse-hover' | 'bg-fill-inverse' | 'bg-fill-magic-secondary-active' | 'bg-fill-magic-secondary-hover' | 'bg-fill-magic-secondary' | 'bg-fill-magic' | 'bg-fill-secondary-active' | 'bg-fill-secondary-hover' | 'bg-fill-secondary' | 'bg-fill-selected' | 'bg-fill-success-active' | 'bg-fill-success-hover' | 'bg-fill-success-secondary' | 'bg-fill-success' | 'bg-fill-tertiary-active' | 'bg-fill-tertiary-hover' | 'bg-fill-tertiary' | 'bg-fill-transparent-active' | 'bg-fill-transparent-hover' | 'bg-fill-transparent-secondary-active' | 'bg-fill-transparent-secondary-hover' | 'bg-fill-transparent-secondary' | 'bg-fill-transparent-selected' | 'bg-fill-transparent' | 'bg-fill-warning-active' | 'bg-fill-warning-hover' | 'bg-fill-warning-secondary' | 'bg-fill-warning' | 'bg-fill' | 'bg-inverse' | 'bg-surface-active' | 'bg-surface-brand-active' | 'bg-surface-brand-hover' | 'bg-surface-brand-selected' | 'bg-surface-brand' | 'bg-surface-caution-active' | 'bg-surface-caution-hover' | 'bg-surface-caution' | 'bg-surface-critical-active' | 'bg-surface-critical-hover' | 'bg-surface-critical' | 'bg-surface-disabled' | 'bg-surface-emphasis-active' | 'bg-surface-emphasis-hover' | 'bg-surface-emphasis' | 'bg-surface-hover' | 'bg-surface-info-active' | 'bg-surface-info-hover' | 'bg-surface-info' | 'bg-surface-inverse' | 'bg-surface-magic-active' | 'bg-surface-magic-hover' | 'bg-surface-magic' | 'bg-surface-secondary-active' | 'bg-surface-secondary-hover' | 'bg-surface-secondary-selected' | 'bg-surface-secondary' | 'bg-surface-selected' | 'bg-surface-success-active' | 'bg-surface-success-hover' | 'bg-surface-success' | 'bg-surface-tertiary-active' | 'bg-surface-tertiary-hover' | 'bg-surface-tertiary' | 'bg-surface-transparent' | 'bg-surface-warning-active' | 'bg-surface-warning-hover' | 'bg-surface-warning' | 'bg-surface' | 'bg'
/** Specialty and component background colors. */
 | 'avatar-bg-fill' | 'avatar-five-bg-fill' | 'avatar-four-bg-fill' | 'avatar-one-bg-fill' | 'avatar-seven-bg-fill' | 'avatar-six-bg-fill' | 'avatar-three-bg-fill' | 'avatar-two-bg-fill' | 'backdrop-bg' | 'button-gradient-bg-fill' | 'checkbox-bg-surface-disabled' | 'input-bg-surface-active' | 'input-bg-surface-hover' | 'input-bg-surface' | 'nav-bg-surface-active' | 'nav-bg-surface-hover' | 'nav-bg-surface-selected' | 'nav-bg-surface' | 'nav-bg' | 'radio-button-bg-surface-disabled' | 'video-thumbnail-play-button-bg-fill-hover' | 'video-thumbnail-play-button-bg-fill' | 'scrollbar-thumb-bg-hover';
export type ColorBorderAlias = 'border-brand' | 'border-caution' | 'border-critical-secondary' | 'border-critical' | 'border-disabled' | 'border-emphasis-active' | 'border-emphasis-hover' | 'border-emphasis' | 'border-focus' | 'border-hover' | 'border-info' | 'border-inverse-active' | 'border-inverse-hover' | 'border-inverse' | 'border-magic-secondary' | 'border-magic-secondary-hover' | 'border-magic' | 'border-secondary' | 'border-success' | 'border-tertiary' | 'border-warning' | 'border'
/** Specialty and component border colors. */
 | 'input-border-active' | 'input-border-hover' | 'input-border';
export type ColorIconAlias = 'icon-active' | 'icon-brand' | 'icon-caution' | 'icon-critical' | 'icon-disabled' | 'icon-emphasis-active' | 'icon-emphasis-hover' | 'icon-emphasis' | 'icon-hover' | 'icon-info' | 'icon-inverse' | 'icon-magic' | 'icon-secondary-active' | 'icon-secondary-hover' | 'icon-secondary' | 'icon-success' | 'icon-warning' | 'icon'
/** Specialty and component icon colors. */
 | 'checkbox-icon-disabled' | 'radio-button-icon-disabled';
export type ColorTextAlias = 'text-brand-hover' | 'text-brand-on-bg-fill-active' | 'text-brand-on-bg-fill-disabled' | 'text-brand-on-bg-fill-hover' | 'text-brand-on-bg-fill' | 'text-brand' | 'text-caution-secondary' | 'text-caution-active' | 'text-caution-hover' | 'text-caution-on-bg-fill' | 'text-caution' | 'text-critical-secondary' | 'text-critical-active' | 'text-critical-hover' | 'text-critical-on-bg-fill' | 'text-critical' | 'text-disabled' | 'text-emphasis-active' | 'text-emphasis-hover' | 'text-emphasis-on-bg-fill-active' | 'text-emphasis-on-bg-fill-hover' | 'text-emphasis-on-bg-fill' | 'text-emphasis' | 'text-info-secondary' | 'text-info-active' | 'text-info-hover' | 'text-info-on-bg-fill' | 'text-info' | 'text-inverse-secondary' | 'text-inverse' | 'text-link-active' | 'text-link-hover' | 'text-link-inverse' | 'text-link' | 'text-magic-on-bg-fill' | 'text-magic' | 'text-magic-secondary' | 'text-secondary' | 'text-success-secondary' | 'text-success-active' | 'text-success-hover' | 'text-success-on-bg-fill' | 'text-success' | 'text-warning-secondary' | 'text-warning-active' | 'text-warning-hover' | 'text-warning-on-bg-fill' | 'text-warning' | 'text'
/** Specialty and component text colors. */
 | 'avatar-five-text-on-bg-fill' | 'avatar-four-text-on-bg-fill' | 'avatar-one-text-on-bg-fill' | 'avatar-seven-text-on-bg-fill' | 'avatar-six-text-on-bg-fill' | 'avatar-text-on-bg-fill' | 'avatar-three-text-on-bg-fill' | 'avatar-two-text-on-bg-fill' | 'video-thumbnail-play-button-text-on-bg-fill';
export type ColorTokenName = `color-${ColorBackgroundAlias}` | `color-${ColorBorderAlias}` | `color-${ColorIconAlias}` | `color-${ColorTextAlias}`;
export type ColorTokenGroup = {
    [TokenName in ColorTokenName]: string;
};
export declare const color: {
    [TokenName in ColorTokenName]: MetaTokenProperties;
};
//# sourceMappingURL=color.d.ts.map