'use strict';

var React = require('react');
var polarisIcons = require('@shopify/polaris-icons');
var breakpoints = require('../../../../utilities/breakpoints.js');
var SearchField_module = require('./SearchField.scss.js');
var TextField = require('../../../TextField/TextField.js');
var Icon = require('../../../Icon/Icon.js');
var Spinner = require('../../../Spinner/Spinner.js');

function SearchField({
  onChange,
  onClear,
  onFocus,
  onBlur,
  focused,
  value,
  placeholder,
  disabled,
  borderlessQueryField,
  loading
}) {
  const id = React.useId();
  const {
    mdUp
  } = breakpoints.useBreakpoints();
  function handleChange(value) {
    onChange(value);
  }
  function handleClear() {
    if (onClear) {
      onClear();
    } else {
      onChange('');
    }
  }
  return /*#__PURE__*/React.createElement(TextField.TextField, {
    id: id,
    value: value,
    onChange: eventValue => handleChange(eventValue ?? value),
    onFocus: onFocus,
    onBlur: onBlur,
    onClearButtonClick: handleClear,
    autoComplete: "off",
    placeholder: placeholder,
    disabled: disabled,
    variant: borderlessQueryField ? 'borderless' : 'inherit',
    size: "slim",
    prefix: mdUp ? /*#__PURE__*/React.createElement(Icon.Icon, {
      source: polarisIcons.SearchIcon
    }) : undefined,
    suffix: loading ? /*#__PURE__*/React.createElement("div", {
      className: SearchField_module.default.Spinner
    }, /*#__PURE__*/React.createElement(Spinner.Spinner, {
      size: "small"
    })) : null,
    focused: focused,
    label: placeholder,
    labelHidden: true,
    clearButton: true
  });
}

exports.SearchField = SearchField;
