'use strict';

var React = require('react');
var reactTransitionGroup = require('react-transition-group');
var css = require('../../../../utilities/css.js');
var useDeepEffect = require('../../../../utilities/use-deep-effect.js');
var useDeepCallback = require('../../../../utilities/use-deep-callback.js');
var ToastManager_module = require('./ToastManager.scss.js');
var Toast = require('../Toast/Toast.js');
var Portal = require('../../../Portal/Portal.js');
var EventListener = require('../../../EventListener/EventListener.js');

const ToastManager = /*#__PURE__*/React.memo(function ToastManager({
  toastMessages
}) {
  const toastNodes = [];
  const updateToasts = useDeepCallback.useDeepCallback(() => {
    let targetInPos = 0;
    toastMessages.forEach((_, index) => {
      const currentToast = toastNodes[index];
      if (!currentToast.current) return;
      targetInPos += currentToast.current.clientHeight;
      currentToast.current.style.setProperty('--pc-toast-manager-translate-y-in', `-${targetInPos}px`);
      currentToast.current.style.setProperty('--pc-toast-manager-translate-y-out', `${-targetInPos + 150}px`);
    });
  }, [toastMessages, toastNodes]);
  useDeepEffect.useDeepEffect(() => {
    updateToasts();
  }, [toastMessages]);
  const toastsMarkup = toastMessages.map((toast, index) => {
    const toastNode = /*#__PURE__*/React.createRef();
    toastNodes[index] = toastNode;
    return /*#__PURE__*/React.createElement(reactTransitionGroup.CSSTransition, {
      nodeRef: toastNodes[index],
      key: toast.id,
      timeout: {
        enter: 0,
        exit: 400
      },
      classNames: toastClasses
    }, /*#__PURE__*/React.createElement("div", {
      ref: toastNode
    }, /*#__PURE__*/React.createElement(Toast.Toast, toast)));
  });
  return /*#__PURE__*/React.createElement(Portal.Portal, {
    idPrefix: "toast"
  }, /*#__PURE__*/React.createElement(EventListener.EventListener, {
    event: "resize",
    handler: updateToasts
  }), /*#__PURE__*/React.createElement("div", {
    className: ToastManager_module.default.ToastManager,
    "aria-live": "assertive"
  }, /*#__PURE__*/React.createElement(reactTransitionGroup.TransitionGroup, {
    component: null
  }, toastsMarkup)));
});
const toastClasses = {
  enter: css.classNames(ToastManager_module.default.ToastWrapper, ToastManager_module.default['ToastWrapper-enter']),
  enterDone: css.classNames(ToastManager_module.default.ToastWrapper, ToastManager_module.default['ToastWrapper-enter-done']),
  exit: css.classNames(ToastManager_module.default.ToastWrapper, ToastManager_module.default['ToastWrapper-exit'])
};

exports.ToastManager = ToastManager;
