'use strict';

var React = require('react');
var polarisIcons = require('@shopify/polaris-icons');
var InlineError_module = require('./InlineError.scss.js');
var Icon = require('../Icon/Icon.js');

function InlineError({
  message,
  fieldID
}) {
  if (!message) {
    return null;
  }
  return /*#__PURE__*/React.createElement("div", {
    id: errorTextID(fieldID),
    className: InlineError_module.default.InlineError
  }, /*#__PURE__*/React.createElement("div", {
    className: InlineError_module.default.Icon
  }, /*#__PURE__*/React.createElement(Icon.Icon, {
    source: polarisIcons.AlertCircleIcon
  })), message);
}
function errorTextID(id) {
  return `${id}Error`;
}

exports.InlineError = InlineError;
exports.errorTextID = errorTextID;
