'use strict';

var React = require('react');
var polarisIcons = require('@shopify/polaris-icons');
var css = require('../../utilities/css.js');
var focus = require('../../utilities/focus.js');
var Tag_module = require('./Tag.scss.js');
var hooks = require('../../utilities/i18n/hooks.js');
var Icon = require('../Icon/Icon.js');

function Tag({
  children,
  disabled = false,
  onClick,
  onRemove,
  accessibilityLabel,
  url
}) {
  const i18n = hooks.useI18n();
  const segmented = onRemove && url;
  const className = css.classNames(Tag_module.default.Tag, disabled && Tag_module.default.disabled, onClick && Tag_module.default.clickable, onRemove && Tag_module.default.removable, url && !disabled && Tag_module.default.linkable, segmented && Tag_module.default.segmented);
  if (onClick) {
    return /*#__PURE__*/React.createElement("button", {
      type: "button",
      disabled: disabled,
      className: className,
      onClick: onClick
    }, children);
  }
  let tagTitle = accessibilityLabel;
  if (!tagTitle) {
    tagTitle = typeof children === 'string' ? children : undefined;
  }
  const ariaLabel = i18n.translate('Polaris.Tag.ariaLabel', {
    children: tagTitle || ''
  });
  const removeButton = onRemove ? /*#__PURE__*/React.createElement("button", {
    type: "button",
    "aria-label": ariaLabel,
    className: css.classNames(Tag_module.default.Button, segmented && Tag_module.default.segmented),
    onClick: onRemove,
    onMouseUp: focus.handleMouseUpByBlurring,
    disabled: disabled
  }, /*#__PURE__*/React.createElement(Icon.Icon, {
    source: polarisIcons.XSmallIcon
  })) : null;
  const tagContent = url && !disabled ? /*#__PURE__*/React.createElement("a", {
    className: css.classNames(Tag_module.default.Link, segmented && Tag_module.default.segmented),
    href: url
  }, /*#__PURE__*/React.createElement("span", {
    title: tagTitle,
    className: Tag_module.default.LinkText
  }, children)) : /*#__PURE__*/React.createElement("span", {
    title: tagTitle,
    className: Tag_module.default.TagText
  }, children);
  return /*#__PURE__*/React.createElement("span", {
    className: className,
    "aria-disabled": disabled
  }, tagContent, removeButton);
}

exports.Tag = Tag;
