import React, { useId } from 'react';
import { SearchIcon } from '@shopify/polaris-icons';
import { useBreakpoints } from '../../../../utilities/breakpoints.js';
import styles from './SearchField.scss.js';
import { TextField } from '../../../TextField/TextField.js';
import { Icon } from '../../../Icon/Icon.js';
import { Spinner } from '../../../Spinner/Spinner.js';

function SearchField({
  onChange,
  onClear,
  onFocus,
  onBlur,
  focused,
  value,
  placeholder,
  disabled,
  borderlessQueryField,
  loading
}) {
  const id = useId();
  const {
    mdUp
  } = useBreakpoints();
  function handleChange(value) {
    onChange(value);
  }
  function handleClear() {
    if (onClear) {
      onClear();
    } else {
      onChange('');
    }
  }
  return /*#__PURE__*/React.createElement(TextField, {
    id: id,
    value: value,
    onChange: eventValue => handleChange(eventValue ?? value),
    onFocus: onFocus,
    onBlur: onBlur,
    onClearButtonClick: handleClear,
    autoComplete: "off",
    placeholder: placeholder,
    disabled: disabled,
    variant: borderlessQueryField ? 'borderless' : 'inherit',
    size: "slim",
    prefix: mdUp ? /*#__PURE__*/React.createElement(Icon, {
      source: SearchIcon
    }) : undefined,
    suffix: loading ? /*#__PURE__*/React.createElement("div", {
      className: styles.Spinner
    }, /*#__PURE__*/React.createElement(Spinner, {
      size: "small"
    })) : null,
    focused: focused,
    label: placeholder,
    labelHidden: true,
    clearButton: true
  });
}

export { SearchField };
