import React from 'react';
import { classNames, variationName } from '../../utilities/css.js';
import styles from './Icon.scss.js';
import { Text } from '../Text/Text.js';

function Icon({
  source,
  tone,
  accessibilityLabel
}) {
  let sourceType;
  if (typeof source === 'function') {
    sourceType = 'function';
  } else if (source === 'placeholder') {
    sourceType = 'placeholder';
  } else {
    sourceType = 'external';
  }
  if (tone && sourceType === 'external' && process.env.NODE_ENV === 'development') {
    // eslint-disable-next-line no-console
    console.warn('Recoloring external SVGs is not supported. Set the intended color on your SVG instead.');
  }
  const className = classNames(styles.Icon, tone && styles[variationName('tone', tone)]);
  const SourceComponent = source;
  const contentMarkup = {
    function: /*#__PURE__*/React.createElement(SourceComponent, {
      className: styles.Svg,
      focusable: "false",
      "aria-hidden": "true"
    }),
    placeholder: /*#__PURE__*/React.createElement("div", {
      className: styles.Placeholder
    }),
    external: /*#__PURE__*/React.createElement("img", {
      className: styles.Img,
      src: `data:image/svg+xml;utf8,${source}`,
      alt: "",
      "aria-hidden": "true"
    })
  };
  return /*#__PURE__*/React.createElement("span", {
    className: className
  }, accessibilityLabel && /*#__PURE__*/React.createElement(Text, {
    as: "span",
    visuallyHidden: true
  }, accessibilityLabel), contentMarkup[sourceType]);
}

export { Icon };
