import React from 'react';
import { getResponsiveProps } from '../../utilities/css.js';
import styles from './InlineStack.scss.js';

const InlineStack = function InlineStack({
  as: Element = 'div',
  align,
  blockAlign,
  gap,
  wrap = true,
  children
}) {
  const style = {
    '--pc-inline-stack-align': align,
    '--pc-inline-stack-block-align': blockAlign,
    '--pc-inline-stack-wrap': wrap ? 'wrap' : 'nowrap',
    ...getResponsiveProps('inline-stack', 'gap', 'space', gap)
  };
  return /*#__PURE__*/React.createElement(Element, {
    className: styles.InlineStack,
    style: style
  }, children);
};

export { InlineStack };
