import { useContext, createContext } from 'react';
import { themes } from '@shopify/polaris-tokens';

function getTheme(themeName) {
  return themes[themeName];
}
const ThemeContext = /*#__PURE__*/createContext(null);
function useTheme() {
  const theme = useContext(ThemeContext);
  if (!theme) {
    throw new Error('No theme was provided. Your application must be wrapped in an <AppProvider> component. See https://polaris.shopify.com/components/app-provider for implementation instructions.');
  }
  return theme;
}
function UseTheme(props) {
  const theme = useTheme();
  return props.children(theme);
}

export { ThemeContext, UseTheme, getTheme, useTheme };
