import type { MetadataProperties } from '../types';
export declare type ColorsBackgroundTokenAlias = 'background' | 'background-hovered' | 'background-pressed' | 'background-selected';
export declare type ColorsActionTokenAlias = 'action-critical' | 'action-critical-depressed' | 'action-critical-disabled' | 'action-critical-hovered' | 'action-critical-pressed' | 'action-primary' | 'action-primary-depressed' | 'action-primary-disabled' | 'action-primary-hovered' | 'action-primary-pressed' | 'action-secondary' | 'action-secondary-depressed' | 'action-secondary-disabled' | 'action-secondary-hovered' | 'action-secondary-hovered-dark' | 'action-secondary-pressed' | 'action-secondary-pressed-dark';
export declare type ColorsSurfaceTokenAlias = 'surface' | 'surface-attention' | 'surface-critical' | 'surface-critical-subdued' | 'surface-critical-subdued-depressed' | 'surface-critical-subdued-hovered' | 'surface-critical-subdued-pressed' | 'surface-dark' | 'surface-depressed' | 'surface-disabled' | 'surface-highlight' | 'surface-highlight-subdued' | 'surface-highlight-subdued-hovered' | 'surface-highlight-subdued-pressed' | 'surface-hovered' | 'surface-hovered-dark' | 'surface-neutral' | 'surface-neutral-disabled' | 'surface-neutral-hovered' | 'surface-neutral-pressed' | 'surface-neutral-subdued' | 'surface-neutral-subdued-dark' | 'surface-pressed' | 'surface-pressed-dark' | 'surface-primary-selected' | 'surface-primary-selected-hovered' | 'surface-primary-selected-pressed' | 'surface-search-field' | 'surface-search-field-dark' | 'surface-selected' | 'surface-selected-hovered' | 'surface-selected-pressed' | 'surface-subdued' | 'surface-success' | 'surface-success-subdued' | 'surface-success-subdued-hovered' | 'surface-success-subdued-pressed' | 'surface-warning' | 'surface-warning-subdued' | 'surface-warning-subdued-hovered' | 'surface-warning-subdued-pressed';
export declare type ColorsBackdropTokenAlias = 'backdrop';
export declare type ColorsOverlayTokenAlias = 'overlay';
export declare type ColorsBorderTokenAlias = 'border' | 'border-on-dark' | 'border-neutral-subdued' | 'border-hovered' | 'border-disabled' | 'border-subdued' | 'border-depressed' | 'border-shadow' | 'border-shadow-subdued' | 'border-critical' | 'border-critical-subdued' | 'border-critical-disabled' | 'border-warning' | 'border-warning-subdued' | 'border-highlight' | 'border-highlight-subdued' | 'border-success' | 'border-success-subdued';
export declare type ColorsTokenName = ColorsBackgroundTokenAlias | ColorsActionTokenAlias | ColorsSurfaceTokenAlias | ColorsBackdropTokenAlias | ColorsOverlayTokenAlias | ColorsBorderTokenAlias | 'decorative-five-icon' | 'decorative-five-surface' | 'decorative-five-text' | 'decorative-four-icon' | 'decorative-four-surface' | 'decorative-four-text' | 'decorative-one-icon' | 'decorative-one-surface' | 'decorative-one-text' | 'decorative-three-icon' | 'decorative-three-surface' | 'decorative-three-text' | 'decorative-two-icon' | 'decorative-two-surface' | 'decorative-two-text' | 'divider-dark' | 'divider' | 'focused' | 'hint-from-direct-light' | 'icon-attention' | 'icon-critical' | 'icon-disabled' | 'icon-highlight' | 'icon-hovered' | 'icon-on-critical' | 'icon-on-dark' | 'icon-on-interactive' | 'icon-on-primary' | 'icon-pressed' | 'icon-subdued' | 'icon-success' | 'icon-warning' | 'icon' | 'interactive-critical-disabled' | 'interactive-critical-hovered' | 'interactive-critical-pressed' | 'interactive-critical' | 'interactive-disabled' | 'interactive-hovered' | 'interactive-on-dark' | 'interactive-pressed-on-dark' | 'interactive-pressed' | 'interactive' | 'shadow-color-picker-dragger' | 'shadow-color-picker' | 'text' | 'text-critical' | 'text-disabled' | 'text-highlight' | 'text-on-critical' | 'text-on-dark' | 'text-on-interactive' | 'text-on-primary' | 'text-primary-hovered' | 'text-primary-pressed' | 'text-primary' | 'text-subdued-on-dark' | 'text-subdued' | 'text-success' | 'text-warning';
export declare type ColorsTokenGroup = {
    [TokenName in ColorsTokenName]: string;
};
export declare const colors: {
    [TokenName in ColorsTokenName]: MetadataProperties;
};
//# sourceMappingURL=colors.d.ts.map