"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AugmentedThemeDocset = void 0;
const utils_1 = require("./utils");
const toFilterEntry = (name) => ({ name });
const aliasedFilters = ['camelcase', 'handle', 't'];
const undocumentedFilters = [
    '_online_store_editor_live_setting',
    'addresses_url',
    'app_block_path?',
    'app_block_path_for',
    'app_extension_path?',
    'app_snippet_path?',
    'cancel_customer_order_link',
    'debug',
    'delete_customer_address_link',
    'dev_shop?',
    'distance_from',
    'edit_customer_address_link',
    'encode_url_component',
    'excerpt',
    'format_code',
    'global_block_type?',
    'h',
    'handle_from',
    'installments_pricing',
    'link_to_theme',
    'login_button',
    'login_url',
    'logout_url',
    'pad_spaces',
    'paragraphize',
    'recover_password_link',
    'recover_url',
    'register_url',
    'registration_uuid_from',
    'root_account_url',
    'sentence',
    'theme_url',
    'unit',
    'weight',
];
const toObjectEntry = (name) => ({ name });
const undocumentedObjects = ['customer_address', 'product_variant'];
const toTagEntry = (name) => ({ name });
const undocumentedTags = ['elsif', 'ifchanged', 'when', 'schema'];
class AugmentedThemeDocset {
    constructor(themeDocset) {
        this.themeDocset = themeDocset;
        this.isAugmented = true;
        this.filters = (0, utils_1.memo)(async () => {
            return [
                ...(await this.themeDocset.filters()),
                ...aliasedFilters.map(toFilterEntry),
                ...undocumentedFilters.map(toFilterEntry),
            ];
        });
        this.objects = (0, utils_1.memo)(async () => {
            return [...(await this.themeDocset.objects()), ...undocumentedObjects.map(toObjectEntry)];
        });
        this.tags = (0, utils_1.memo)(async () => {
            return [...(await this.themeDocset.tags()), ...undocumentedTags.map(toTagEntry)];
        });
        this.systemTranslations = (0, utils_1.memo)(async () => {
            return this.themeDocset.systemTranslations();
        });
    }
}
exports.AugmentedThemeDocset = AugmentedThemeDocset;
//# sourceMappingURL=AugmentedThemeDocset.js.map