import { ConfigTarget, JSONCheckDefinition, LiquidCheckDefinition } from '../types';
export declare const allChecks: (LiquidCheckDefinition | JSONCheckDefinition)[];
/**
 * The recommended checks is populated by all checks with the following conditions:
 * - meta.docs.recommended: true
 * - Either no meta.targets list exist or if it does exist then Recommended is a target
 */
export declare const recommended: ({
    meta: {
        name: string;
        code: string;
        aliases?: string[] | undefined;
        severity: import("../types").Severity;
        type: import("../types").SourceCodeType.LiquidHtml;
        docs: {
            description: string;
            recommended?: boolean | undefined;
            url?: string | undefined;
        };
        schema: import("../types").Schema;
        targets?: ConfigTarget[] | undefined;
        deprecated?: boolean | undefined;
        replacedBy?: boolean | undefined;
    };
    create(context: {
        report(problem: {
            message: string;
            startIndex: number;
            endIndex: number;
            fix?: ((corrector: import("..").StringCorrector) => void) | undefined;
            suggest?: {
                message: string;
                fix: (corrector: import("..").StringCorrector) => void;
            }[] | undefined;
        }): void;
        relativePath(absolutePath: string): string;
        absolutePath(relativePath: string): string;
        file: {
            absolutePath: string;
            version?: number | undefined;
            source: string;
            type: import("../types").SourceCodeType.LiquidHtml;
            ast: Error | import("../types").LiquidHtmlNode;
        };
    } & import("../types").Dependencies & {
        settings: import("../types").Settings<import("../types").Schema>;
    }): Partial<Partial<{
        Document: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Document>;
        LiquidRawTag: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidRawTag>;
        LiquidTag: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidTag>;
        LiquidBranch: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidBranch>;
        LiquidVariableOutput: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidVariableOutput>;
        HtmlSelfClosingElement: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlSelfClosingElement>;
        HtmlVoidElement: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlVoidElement>;
        HtmlDoctype: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlDoctype>;
        HtmlComment: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlComment>;
        HtmlElement: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlElement>;
        HtmlDanglingMarkerClose: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlDanglingMarkerClose>;
        HtmlRawNode: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlRawNode>;
        AttrSingleQuoted: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrSingleQuoted>;
        AttrDoubleQuoted: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrDoubleQuoted>;
        AttrUnquoted: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrUnquoted>;
        AttrEmpty: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrEmpty>;
        TextNode: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.TextNode>;
        YAMLFrontmatter: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.YAMLFrontmatter>;
        LiquidVariable: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidVariable>;
        LiquidFilter: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidFilter>;
        NamedArgument: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.NamedArgument>;
        LiquidLiteral: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidLiteral>;
        String: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.String>;
        Number: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Number>;
        Range: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Range>;
        VariableLookup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.VariableLookup>;
        Comparison: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Comparison>;
        LogicalExpression: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LogicalExpression>;
        AssignMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AssignMarkup>;
        CycleMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.CycleMarkup>;
        ForMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.ForMarkup>;
        PaginateMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.PaginateMarkup>;
        RawMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.RawMarkup>;
        RenderMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.RenderMarkup>;
        RenderVariableExpression: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.RenderVariableExpression>;
    } & {
        "Document:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Document>;
        "LiquidRawTag:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidRawTag>;
        "LiquidTag:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidTag>;
        "LiquidBranch:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidBranch>;
        "LiquidVariableOutput:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidVariableOutput>;
        "HtmlSelfClosingElement:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlSelfClosingElement>;
        "HtmlVoidElement:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlVoidElement>;
        "HtmlDoctype:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlDoctype>;
        "HtmlComment:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlComment>;
        "HtmlElement:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlElement>;
        "HtmlDanglingMarkerClose:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlDanglingMarkerClose>;
        "HtmlRawNode:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.HtmlRawNode>;
        "AttrSingleQuoted:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrSingleQuoted>;
        "AttrDoubleQuoted:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrDoubleQuoted>;
        "AttrUnquoted:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrUnquoted>;
        "AttrEmpty:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AttrEmpty>;
        "TextNode:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.TextNode>;
        "YAMLFrontmatter:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.YAMLFrontmatter>;
        "LiquidVariable:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidVariable>;
        "LiquidFilter:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidFilter>;
        "NamedArgument:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.NamedArgument>;
        "LiquidLiteral:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LiquidLiteral>;
        "String:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.String>;
        "Number:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Number>;
        "Range:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Range>;
        "VariableLookup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.VariableLookup>;
        "Comparison:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.Comparison>;
        "LogicalExpression:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.LogicalExpression>;
        "AssignMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.AssignMarkup>;
        "CycleMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.CycleMarkup>;
        "ForMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.ForMarkup>;
        "PaginateMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.PaginateMarkup>;
        "RawMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.RawMarkup>;
        "RenderMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.RenderMarkup>;
        "RenderVariableExpression:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("../types").LiquidHtmlNodeTypes.RenderVariableExpression>;
    } & {
        onCodePathStart(file: {
            absolutePath: string;
            version?: number | undefined;
            source: string;
            type: import("../types").SourceCodeType.LiquidHtml;
            ast: Error | import("../types").LiquidHtmlNode;
        }): Promise<void>;
        onCodePathEnd(file: {
            absolutePath: string;
            version?: number | undefined;
            source: string;
            type: import("../types").SourceCodeType.LiquidHtml;
            ast: Error | import("../types").LiquidHtmlNode;
        } & {
            ast: import("../types").LiquidHtmlNode;
        }): Promise<void>;
    }>>;
} | {
    meta: {
        name: string;
        code: string;
        aliases?: string[] | undefined;
        severity: import("../types").Severity;
        type: import("../types").SourceCodeType.JSON;
        docs: {
            description: string;
            recommended?: boolean | undefined;
            url?: string | undefined;
        };
        schema: import("../types").Schema;
        targets?: ConfigTarget[] | undefined;
        deprecated?: boolean | undefined;
        replacedBy?: boolean | undefined;
    };
    create(context: {
        report(problem: {
            message: string;
            startIndex: number;
            endIndex: number;
            fix?: ((corrector: import("..").JSONCorrector) => void) | undefined;
            suggest?: {
                message: string;
                fix: (corrector: import("..").JSONCorrector) => void;
            }[] | undefined;
        }): void;
        relativePath(absolutePath: string): string;
        absolutePath(relativePath: string): string;
        file: {
            absolutePath: string;
            version?: number | undefined;
            source: string;
            type: import("../types").SourceCodeType.JSON;
            ast: Error | import("../types").JSONNode;
        };
    } & import("../types").Dependencies & {
        settings: import("../types").Settings<import("../types").Schema>;
    }): Partial<Partial<{
        Object: import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Object">;
        Property: import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Property">;
        Identifier: import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Identifier">;
        Array: import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Array">;
        Literal: import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Literal">;
    } & {
        "Object:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Object">;
        "Property:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Property">;
        "Identifier:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Identifier">;
        "Array:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Array">;
        "Literal:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.JSON, "Literal">;
    } & {
        onCodePathStart(file: {
            absolutePath: string;
            version?: number | undefined;
            source: string;
            type: import("../types").SourceCodeType.JSON;
            ast: Error | import("../types").JSONNode;
        }): Promise<void>;
        onCodePathEnd(file: {
            absolutePath: string;
            version?: number | undefined;
            source: string;
            type: import("../types").SourceCodeType.JSON;
            ast: Error | import("../types").JSONNode;
        } & {
            ast: import("../types").JSONNode;
        }): Promise<void>;
    }>>;
})[];
