"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.recommended = exports.allChecks = void 0;
const types_1 = require("../types");
const app_block_valid_tags_1 = require("./app-block-valid-tags");
const asset_preload_1 = require("./asset-preload");
const asset_size_app_block_css_1 = require("./asset-size-app-block-css");
const asset_size_app_block_javascript_1 = require("./asset-size-app-block-javascript");
const asset_size_css_1 = require("./asset-size-css");
const asset_size_javascript_1 = require("./asset-size-javascript");
const cdn_preconnect_1 = require("./cdn-preconnect");
const content_for_header_modification_1 = require("./content-for-header-modification");
const deprecate_bgsizes_1 = require("./deprecate-bgsizes");
const deprecate_lazysizes_1 = require("./deprecate-lazysizes");
const deprecated_filter_1 = require("./deprecated-filter");
const deprecated_tag_1 = require("./deprecated-tag");
const img_width_and_height_1 = require("./img-width-and-height");
const json_syntax_error_1 = require("./json-syntax-error");
const liquid_html_syntax_error_1 = require("./liquid-html-syntax-error");
const matching_translations_1 = require("./matching-translations");
const missing_asset_1 = require("./missing-asset");
const missing_template_1 = require("./missing-template");
const pagination_size_1 = require("./pagination-size");
const parser_blocking_script_1 = require("./parser-blocking-script");
const remote_asset_1 = require("./remote-asset");
const required_layout_theme_object_1 = require("./required-layout-theme-object");
const translation_key_exists_1 = require("./translation-key-exists");
const unclosed_html_element_1 = require("./unclosed-html-element");
const undefined_object_1 = require("./undefined-object");
const unknown_filter_1 = require("./unknown-filter");
const unused_assign_1 = require("./unused-assign");
const valid_html_translation_1 = require("./valid-html-translation");
const valid_schema_1 = require("./valid-schema");
exports.allChecks = [
    app_block_valid_tags_1.AppBlockValidTags,
    asset_preload_1.AssetPreload,
    asset_size_app_block_css_1.AssetSizeAppBlockCSS,
    asset_size_app_block_javascript_1.AssetSizeAppBlockJavaScript,
    asset_size_css_1.AssetSizeCSS,
    asset_size_javascript_1.AssetSizeJavaScript,
    cdn_preconnect_1.CdnPreconnect,
    content_for_header_modification_1.ContentForHeaderModification,
    deprecate_bgsizes_1.DeprecateBgsizes,
    deprecate_lazysizes_1.DeprecateLazysizes,
    deprecated_filter_1.DeprecatedFilter,
    deprecated_tag_1.DeprecatedTag,
    img_width_and_height_1.ImgWidthAndHeight,
    json_syntax_error_1.JSONSyntaxError,
    liquid_html_syntax_error_1.LiquidHTMLSyntaxError,
    matching_translations_1.MatchingTranslations,
    missing_asset_1.MissingAsset,
    missing_template_1.MissingTemplate,
    pagination_size_1.PaginationSize,
    parser_blocking_script_1.ParserBlockingScript,
    remote_asset_1.RemoteAsset,
    required_layout_theme_object_1.RequiredLayoutThemeObject,
    translation_key_exists_1.TranslationKeyExists,
    unclosed_html_element_1.UnclosedHTMLElement,
    undefined_object_1.UndefinedObject,
    unknown_filter_1.UnknownFilter,
    unused_assign_1.UnusedAssign,
    valid_html_translation_1.ValidHTMLTranslation,
    valid_schema_1.ValidSchema,
];
/**
 * The recommended checks is populated by all checks with the following conditions:
 * - meta.docs.recommended: true
 * - Either no meta.targets list exist or if it does exist then Recommended is a target
 */
exports.recommended = exports.allChecks.filter((check) => {
    const isRecommended = check.meta.docs.recommended;
    const isValidTarget = !check.meta.targets ||
        !check.meta.targets.length ||
        check.meta.targets.includes(types_1.ConfigTarget.Recommended);
    return isRecommended && isValidTarget;
});
//# sourceMappingURL=index.js.map