"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JSONSyntaxError = void 0;
const types_1 = require("../../types");
const utils_1 = require("../../utils");
function cleanErrorMessage(error) {
    const message = 'rawMessage' in error ? error.rawMessage : error.message;
    return message.replace(/\s+at \d+:\d+/, '');
}
exports.JSONSyntaxError = {
    meta: {
        code: 'JSONSyntaxError',
        aliases: ['ValidJson'],
        name: 'Enforce valid JSON',
        docs: {
            description: 'This check exists to prevent invalid JSON files in themes.',
            recommended: true,
            url: 'https://shopify.dev/docs/themes/tools/theme-check/checks/valid-json',
        },
        type: types_1.SourceCodeType.JSON,
        severity: types_1.Severity.ERROR,
        schema: {},
        targets: [],
    },
    create(context) {
        const error = context.file.ast;
        if (!(0, utils_1.isError)(error))
            return {};
        return {
            async onCodePathStart(file) {
                if ('line' in error &&
                    typeof error.line === 'number' &&
                    'column' in error &&
                    typeof error.column === 'number') {
                    const { line, column } = error;
                    const startIndex = (0, utils_1.getOffset)(file.source, line, column);
                    const endIndex = (0, utils_1.getOffset)(file.source, line, column) + 1;
                    context.report({
                        message: cleanErrorMessage(error),
                        startIndex,
                        endIndex: endIndex,
                    });
                }
                else {
                    context.report({
                        message: cleanErrorMessage(error),
                        startIndex: 0,
                        endIndex: file.source.length,
                    });
                }
            },
        };
    },
};
//# sourceMappingURL=index.js.map