"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isLiquidString = exports.hasAttributeValueOf = exports.valueIncludes = exports.isValuedHtmlAttribute = exports.isHtmlAttribute = exports.isAttr = exports.isHtmlTag = exports.isLiquidBranch = exports.isNodeOfType = void 0;
const liquid_html_parser_1 = require("@shopify/liquid-html-parser");
function isNodeOfType(type, node) {
    return (node === null || node === void 0 ? void 0 : node.type) === type;
}
exports.isNodeOfType = isNodeOfType;
function isLiquidBranch(node) {
    return isNodeOfType(liquid_html_parser_1.NodeTypes.LiquidBranch, node);
}
exports.isLiquidBranch = isLiquidBranch;
function isHtmlTag(node, name) {
    return (node.name.length === 1 &&
        node.name[0].type === liquid_html_parser_1.NodeTypes.TextNode &&
        node.name[0].value === name &&
        !!node.blockEndPosition);
}
exports.isHtmlTag = isHtmlTag;
function isAttr(attr, name) {
    return (attr.name.length === 1 &&
        isNodeOfType(liquid_html_parser_1.NodeTypes.TextNode, attr.name[0]) &&
        attr.name[0].value === name);
}
exports.isAttr = isAttr;
function isHtmlAttribute(attr) {
    return [
        liquid_html_parser_1.NodeTypes.AttrUnquoted,
        liquid_html_parser_1.NodeTypes.AttrDoubleQuoted,
        liquid_html_parser_1.NodeTypes.AttrSingleQuoted,
        liquid_html_parser_1.NodeTypes.AttrEmpty,
    ].some((type) => isNodeOfType(type, attr));
}
exports.isHtmlAttribute = isHtmlAttribute;
function isValuedHtmlAttribute(attr) {
    return [liquid_html_parser_1.NodeTypes.AttrUnquoted, liquid_html_parser_1.NodeTypes.AttrDoubleQuoted, liquid_html_parser_1.NodeTypes.AttrSingleQuoted].some((type) => isNodeOfType(type, attr));
}
exports.isValuedHtmlAttribute = isValuedHtmlAttribute;
function valueIncludes(attr, word) {
    const regex = new RegExp(`(^|\\s)${word}(\\s|$)`, 'g');
    return attr.value
        .filter((node) => isNodeOfType(liquid_html_parser_1.NodeTypes.TextNode, node))
        .some((valueNode) => regex.test(valueNode.value));
}
exports.valueIncludes = valueIncludes;
function hasAttributeValueOf(attr, value) {
    return (attr.value.length === 1 &&
        isNodeOfType(liquid_html_parser_1.NodeTypes.TextNode, attr.value[0]) &&
        attr.value[0].value === value);
}
exports.hasAttributeValueOf = hasAttributeValueOf;
function isLiquidString(node) {
    return node.type === liquid_html_parser_1.NodeTypes.String;
}
exports.isLiquidString = isLiquidString;
//# sourceMappingURL=utils.js.map