"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findNodeAtPath = void 0;
const types_1 = require("../../types");
/**
 * Returns the node in a list of nodes that matches the path.
 * This supports cases where the path is an index or a key.
 */
const findNodeByPath = (nodes, path) => {
    const numPath = Number(path);
    const isIndexPath = !isNaN(numPath);
    if (isIndexPath && nodes.length > numPath) {
        return nodes[numPath];
    }
    return nodes.find((child) => (0, types_1.isPropertyNode)(child) && child.key.value === path);
};
/**
 * Traverse the JSON AST to find the node corresponding to the path
 */
const findNodeAtPath = (node, pathSegments) => {
    const [segment, ...remainingSegments] = pathSegments;
    if ((0, types_1.isObjectNode)(node) || (0, types_1.isArrayNode)(node)) {
        const nodeChildren = node.children;
        const subNode = findNodeByPath(nodeChildren, segment);
        if (subNode && remainingSegments.length > 0) {
            return (0, exports.findNodeAtPath)((0, types_1.isPropertyNode)(subNode) ? subNode.value : subNode, remainingSegments);
        }
        return subNode;
    }
    return undefined;
};
exports.findNodeAtPath = findNodeAtPath;
//# sourceMappingURL=find-node-at-path.js.map