import { LiquidRawTag, Position } from '@shopify/liquid-html-parser';
export declare class JsonParseError extends SyntaxError {
    position: Position;
    constructor(message: string, position: Position);
}
/**
 * Parses the body of a liquid raw tag as JSON and returns the parsed object.
 *
 * When the body is not valid JSON, returns an error message, and the indicies of the error.
 */
export declare const parseJsonBody: (node: LiquidRawTag) => object | Error;
