import { Offense } from '../types';
export declare function createDisabledChecksModule(): {
    DisabledChecksVisitor: {
        meta: {
            name: string;
            code: string;
            aliases?: string[] | undefined;
            severity: import("../types").Severity;
            type: import("../types").SourceCodeType.LiquidHtml;
            docs: {
                description: string;
                recommended?: boolean | undefined;
                url?: string | undefined;
            };
            schema: import("../types").Schema;
            targets?: import("../types").ConfigTarget[] | undefined;
            deprecated?: boolean | undefined;
            replacedBy?: boolean | undefined;
        };
        create(context: {
            report(problem: {
                message: string;
                startIndex: number;
                endIndex: number;
                fix?: ((corrector: import("..").StringCorrector) => void) | undefined;
                suggest?: {
                    message: string;
                    fix: (corrector: import("..").StringCorrector) => void;
                }[] | undefined;
            }): void;
            relativePath(absolutePath: string): string;
            absolutePath(relativePath: string): string;
            file: {
                absolutePath: string;
                version?: number | undefined;
                source: string;
                type: import("../types").SourceCodeType.LiquidHtml;
                ast: Error | import("@shopify/liquid-html-parser").LiquidHtmlNode;
            };
        } & import("../types").Dependencies & {
            settings: import("../types").Settings<import("../types").Schema>;
        }): Partial<Partial<{
            Document: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Document>;
            LiquidRawTag: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidRawTag>;
            LiquidTag: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidTag>;
            LiquidBranch: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidBranch>;
            LiquidVariableOutput: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidVariableOutput>;
            HtmlSelfClosingElement: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlSelfClosingElement>;
            HtmlVoidElement: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlVoidElement>;
            HtmlDoctype: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlDoctype>;
            HtmlComment: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlComment>;
            HtmlElement: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlElement>;
            HtmlDanglingMarkerClose: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlDanglingMarkerClose>;
            HtmlRawNode: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlRawNode>;
            AttrSingleQuoted: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrSingleQuoted>;
            AttrDoubleQuoted: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrDoubleQuoted>;
            AttrUnquoted: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrUnquoted>;
            AttrEmpty: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrEmpty>;
            TextNode: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.TextNode>;
            YAMLFrontmatter: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.YAMLFrontmatter>;
            LiquidVariable: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidVariable>;
            LiquidFilter: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidFilter>;
            NamedArgument: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.NamedArgument>;
            LiquidLiteral: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidLiteral>;
            String: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.String>;
            Number: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Number>;
            Range: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Range>;
            VariableLookup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.VariableLookup>;
            Comparison: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Comparison>;
            LogicalExpression: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LogicalExpression>;
            AssignMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AssignMarkup>;
            CycleMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.CycleMarkup>;
            ForMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.ForMarkup>;
            PaginateMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.PaginateMarkup>;
            RawMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.RawMarkup>;
            RenderMarkup: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.RenderMarkup>;
            RenderVariableExpression: import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.RenderVariableExpression>;
        } & {
            "Document:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Document>;
            "LiquidRawTag:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidRawTag>;
            "LiquidTag:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidTag>;
            "LiquidBranch:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidBranch>;
            "LiquidVariableOutput:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidVariableOutput>;
            "HtmlSelfClosingElement:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlSelfClosingElement>;
            "HtmlVoidElement:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlVoidElement>;
            "HtmlDoctype:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlDoctype>;
            "HtmlComment:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlComment>;
            "HtmlElement:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlElement>;
            "HtmlDanglingMarkerClose:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlDanglingMarkerClose>;
            "HtmlRawNode:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.HtmlRawNode>;
            "AttrSingleQuoted:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrSingleQuoted>;
            "AttrDoubleQuoted:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrDoubleQuoted>;
            "AttrUnquoted:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrUnquoted>;
            "AttrEmpty:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AttrEmpty>;
            "TextNode:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.TextNode>;
            "YAMLFrontmatter:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.YAMLFrontmatter>;
            "LiquidVariable:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidVariable>;
            "LiquidFilter:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidFilter>;
            "NamedArgument:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.NamedArgument>;
            "LiquidLiteral:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LiquidLiteral>;
            "String:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.String>;
            "Number:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Number>;
            "Range:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Range>;
            "VariableLookup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.VariableLookup>;
            "Comparison:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.Comparison>;
            "LogicalExpression:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.LogicalExpression>;
            "AssignMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.AssignMarkup>;
            "CycleMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.CycleMarkup>;
            "ForMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.ForMarkup>;
            "PaginateMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.PaginateMarkup>;
            "RawMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.RawMarkup>;
            "RenderMarkup:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.RenderMarkup>;
            "RenderVariableExpression:exit": import("../types").CheckNodeMethod<import("../types").SourceCodeType.LiquidHtml, import("@shopify/liquid-html-parser").NodeTypes.RenderVariableExpression>;
        } & {
            onCodePathStart(file: {
                absolutePath: string;
                version?: number | undefined;
                source: string;
                type: import("../types").SourceCodeType.LiquidHtml;
                ast: Error | import("@shopify/liquid-html-parser").LiquidHtmlNode;
            }): Promise<void>;
            onCodePathEnd(file: {
                absolutePath: string;
                version?: number | undefined;
                source: string;
                type: import("../types").SourceCodeType.LiquidHtml;
                ast: Error | import("@shopify/liquid-html-parser").LiquidHtmlNode;
            } & {
                ast: import("@shopify/liquid-html-parser").LiquidHtmlNode;
            }): Promise<void>;
        }>>;
    };
    isDisabled: (offense: Offense) => boolean;
};
