"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.check = void 0;
const types_1 = require("./types");
const visitors_1 = require("./visitors");
const disabled_checks_1 = require("./disabled-checks");
const path = __importStar(require("./path"));
const utils_1 = require("./utils");
const ignore_1 = require("./ignore");
const AugmentedThemeDocset_1 = require("./AugmentedThemeDocset");
const AugmentedSchemaValidators_1 = require("./AugmentedSchemaValidators");
__exportStar(require("./AugmentedThemeDocset"), exports);
__exportStar(require("./AugmentedSchemaValidators"), exports);
__exportStar(require("./fixes"), exports);
__exportStar(require("./types"), exports);
__exportStar(require("./checks"), exports);
__exportStar(require("./to-source-code"), exports);
__exportStar(require("./ignore"), exports);
__exportStar(require("./utils/types"), exports);
__exportStar(require("./utils/memo"), exports);
const defaultErrorHandler = (_error) => {
    // Silently ignores errors by default.
};
async function check(sourceCodes, config, dependencies) {
    const pipelines = [];
    const offenses = [];
    const { DisabledChecksVisitor, isDisabled } = (0, disabled_checks_1.createDisabledChecksModule)();
    // We're memozing those deps here because they shouldn't change within a run.
    if (dependencies.themeDocset && !dependencies.themeDocset.isAugmented) {
        dependencies.themeDocset = new AugmentedThemeDocset_1.AugmentedThemeDocset(dependencies.themeDocset);
    }
    if (dependencies.schemaValidators && !dependencies.schemaValidators.isAugmented) {
        dependencies.schemaValidators = new AugmentedSchemaValidators_1.AugmentedSchemaValidators(dependencies.schemaValidators);
    }
    for (const type of Object.values(types_1.SourceCodeType)) {
        switch (type) {
            case types_1.SourceCodeType.JSON: {
                const files = filesOfType(type, sourceCodes);
                const checkDefs = checksOfType(type, config.checks);
                for (const file of files) {
                    for (const checkDef of checkDefs) {
                        if ((0, ignore_1.isIgnored)(file.absolutePath, config, checkDef))
                            continue;
                        const check = createCheck(checkDef, file, config, offenses, dependencies);
                        pipelines.push(checkJSONFile(check, file));
                    }
                }
                break;
            }
            case types_1.SourceCodeType.LiquidHtml: {
                const files = filesOfType(type, sourceCodes);
                const checkDefs = [DisabledChecksVisitor, ...checksOfType(type, config.checks)];
                for (const file of files) {
                    for (const checkDef of checkDefs) {
                        if ((0, ignore_1.isIgnored)(file.absolutePath, config, checkDef))
                            continue;
                        const check = createCheck(checkDef, file, config, offenses, dependencies);
                        pipelines.push(checkLiquidFile(check, file));
                    }
                }
                break;
            }
        }
    }
    const onRejected = config.onError || defaultErrorHandler;
    await Promise.all(pipelines.map((pipeline) => pipeline.catch(onRejected)));
    return offenses.filter((offense) => !isDisabled(offense));
}
exports.check = check;
function createContext(check, file, offenses, config, dependencies) {
    const checkSettings = config.settings[check.meta.code];
    return {
        ...dependencies,
        settings: createSettings(checkSettings, check.meta.schema),
        absolutePath: (relativePath) => path.join(config.root, relativePath),
        relativePath: (absolutePath) => path.relative(absolutePath, config.root),
        report(problem) {
            var _a;
            offenses.push({
                type: check.meta.type,
                check: check.meta.code,
                message: problem.message,
                absolutePath: file.absolutePath,
                severity: (_a = checkSettings === null || checkSettings === void 0 ? void 0 : checkSettings.severity) !== null && _a !== void 0 ? _a : check.meta.severity,
                start: (0, utils_1.getPosition)(file.source, problem.startIndex),
                end: (0, utils_1.getPosition)(file.source, problem.endIndex),
                fix: problem.fix,
                suggest: problem.suggest,
            });
        },
        file,
    };
}
function createSettings(checkSettings, schema) {
    var _a;
    const settings = {};
    for (const [key, schemaProp] of Object.entries(schema)) {
        settings[key] = (_a = checkSettings === null || checkSettings === void 0 ? void 0 : checkSettings[key]) !== null && _a !== void 0 ? _a : schemaProp.defaultValue();
    }
    return settings;
}
function checksOfType(type, checks) {
    return checks.filter((def) => def.meta.type === type);
}
function createCheck(check, file, config, offenses, dependencies) {
    const context = createContext(check, file, offenses, config, dependencies);
    return check.create(context);
}
function filesOfType(type, sourceCodes) {
    return sourceCodes.filter((file) => file.type === type);
}
async function checkJSONFile(check, file) {
    if (check.onCodePathStart)
        await check.onCodePathStart(file);
    if (file.ast instanceof Error)
        return;
    if (Object.keys(check).length > 0)
        await (0, visitors_1.visitJSON)(file.ast, check);
    if (check.onCodePathEnd)
        await check.onCodePathEnd(file);
}
async function checkLiquidFile(check, file) {
    if (check.onCodePathStart)
        await check.onCodePathStart(file);
    if (file.ast instanceof Error)
        return;
    if (Object.keys(check).length > 0)
        await (0, visitors_1.visitLiquid)(file.ast, check);
    if (check.onCodePathEnd)
        await check.onCodePathEnd(file);
}
//# sourceMappingURL=index.js.map