"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.toSourceCode = void 0;
const liquid_html_parser_1 = require("@shopify/liquid-html-parser");
const json_to_ast_1 = __importDefault(require("json-to-ast"));
const types_1 = require("./types");
function asError(error) {
    if (error instanceof Error) {
        return error;
    }
    else if (typeof error === 'string') {
        return new Error(error);
    }
    else if (error && typeof error.toString === 'function') {
        return new Error(error.toString());
    }
    else {
        return new Error('An unknown error occurred');
    }
}
function parseLiquid(source) {
    try {
        return (0, liquid_html_parser_1.toLiquidHtmlAST)(source);
    }
    catch (error) {
        return asError(error);
    }
}
function parseJSON(source) {
    try {
        return (0, json_to_ast_1.default)(source);
    }
    catch (error) {
        return asError(error);
    }
}
function toSourceCode(absolutePath, source, version) {
    const isLiquid = absolutePath.endsWith('.liquid');
    if (isLiquid) {
        return {
            absolutePath,
            source,
            type: types_1.SourceCodeType.LiquidHtml,
            ast: parseLiquid(source),
            version,
        };
    }
    else {
        return {
            absolutePath,
            source,
            type: types_1.SourceCodeType.JSON,
            ast: parseJSON(source),
            version,
        };
    }
}
exports.toSourceCode = toSourceCode;
//# sourceMappingURL=to-source-code.js.map