import { Context, SourceCodeType, Schema, RelativePath } from '../types';
export declare function assertFileExists<T extends SourceCodeType, S extends Schema>(context: Context<T, S>, filePath: RelativePath): Promise<boolean>;
export declare function assertFileSize<T extends SourceCodeType, S extends Schema>(thresholdInBytes: number, fileSize: number): Promise<boolean>;
export declare function getFileSize(url: string): Promise<number>;
export declare function hasRemoteAssetSizeExceededThreshold(url: string, thresholdInBytes: number): Promise<boolean>;
export declare function hasLocalAssetSizeExceededThreshold<T extends SourceCodeType, S extends Schema>(context: Context<T, S>, path: string, thresholdInBytes: number): Promise<boolean | undefined>;
