"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasLocalAssetSizeExceededThreshold = exports.hasRemoteAssetSizeExceededThreshold = exports.getFileSize = exports.assertFileSize = exports.assertFileExists = void 0;
const cross_fetch_1 = require("cross-fetch");
async function assertFileExists(context, filePath) {
    const absolutePath = context.absolutePath(filePath);
    return await context.fileExists(absolutePath);
}
exports.assertFileExists = assertFileExists;
async function assertFileSize(thresholdInBytes, fileSize) {
    if (fileSize <= thresholdInBytes)
        return false;
    return true;
}
exports.assertFileSize = assertFileSize;
async function getFileSize(url) {
    try {
        const response = await (0, cross_fetch_1.fetch)(url, { method: 'HEAD' });
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        const fileSize = response.headers.get('Content-Length');
        if (fileSize === null)
            return 0;
        return parseFloat(fileSize);
    }
    catch (error) {
        return 0;
    }
}
exports.getFileSize = getFileSize;
async function hasRemoteAssetSizeExceededThreshold(url, thresholdInBytes) {
    const fileSize = await getFileSize(url);
    return fileSize > thresholdInBytes;
}
exports.hasRemoteAssetSizeExceededThreshold = hasRemoteAssetSizeExceededThreshold;
async function hasLocalAssetSizeExceededThreshold(context, path, thresholdInBytes) {
    const absolutePath = `assets/${path}`;
    const fileExists = await assertFileExists(context, absolutePath);
    if (!fileExists)
        return;
    const fileSize = await context.fileSize(absolutePath);
    const fileExceedsThreshold = await assertFileSize(thresholdInBytes, fileSize);
    return fileExceedsThreshold;
}
exports.hasLocalAssetSizeExceededThreshold = hasLocalAssetSizeExceededThreshold;
//# sourceMappingURL=file-utils.js.map