"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withErrorFormatting = void 0;
const getLastToken = (inputString) => {
    const tokens = inputString.split('/');
    return tokens[tokens.length - 1];
};
/**
 * Wraps a json schema validator with formatted error messages for rendering
 */
const withErrorFormatting = (validate) => {
    return (sectionSchema) => {
        var _a;
        validate(sectionSchema);
        const errors = (_a = validate.errors) !== null && _a !== void 0 ? _a : [];
        return errors.map(({ instancePath, message }) => {
            const path = instancePath.replace(/^\//, '').replace(/\//gm, '.');
            return { path, message: `${getLastToken(instancePath)} ${message}` };
        });
    };
};
exports.withErrorFormatting = withErrorFormatting;
//# sourceMappingURL=json-schema-validate-utils.js.map