"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compileJsonSchema = exports.compileJsonSchemaToFile = void 0;
const ajv_1 = __importDefault(require("ajv"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const standalone_1 = __importDefault(require("ajv/dist/standalone"));
/**
 * Attempts to compile all the json schemas within a directory
 *
 * All compatible schemas will be output to the same directory
 */
const compileJsonSchemaToFile = async (dir) => {
    const ajv = new ajv_1.default({ code: { source: true }, strict: false });
    // Read the directory
    fs.readdir(dir, (err, files) => {
        if (err) {
            console.error(`Error reading directory: ${err}`);
            return;
        }
        // Filter JSON schema files by naming convention in theme-check-liquid
        const schemaFiles = files.filter((file) => file.endsWith('_schema.json'));
        schemaFiles.forEach((file) => {
            const filePath = path.join(dir, file);
            // Read and parse each JSON schema
            fs.readFile(filePath, 'utf8', (err, data) => {
                if (err) {
                    console.error(`Error reading file: ${err}`);
                    return;
                }
                const schema = JSON.parse(data);
                // Compile the schema to a validation function and generate the code
                const validate = ajv.compile(schema);
                const moduleCode = (0, standalone_1.default)(ajv, validate);
                // Write the module code to file
                const outputPath = path.join(dir, `${path.basename(file, '.json')}_validator.js`);
                fs.writeFileSync(outputPath, moduleCode);
            });
        });
    });
};
exports.compileJsonSchemaToFile = compileJsonSchemaToFile;
const compileJsonSchema = (jsonSchema) => {
    const ajv = new ajv_1.default({ strict: false });
    return ajv.compile(jsonSchema);
};
exports.compileJsonSchema = compileJsonSchema;
//# sourceMappingURL=jsonSchemaCompiler.js.map