import { FilterEntry, ObjectEntry, TagEntry, ThemeDocset, JsonSchemaValidators, Translations } from '@shopify/theme-check-common';
import { ValidateFunction } from 'ajv';
type Logger = (message: string) => void;
export declare class ThemeLiquidDocsManager implements ThemeDocset, JsonSchemaValidators {
    private log;
    constructor(log?: Logger);
    filters: () => Promise<FilterEntry[]>;
    objects: () => Promise<ObjectEntry[]>;
    tags: () => Promise<TagEntry[]>;
    systemTranslations: () => Promise<Translations>;
    validateSectionSchema: () => Promise<ValidateFunction<unknown>>;
    /**
     * The setup method checks that the latest revision matches the one from
     * Shopify/theme-liquid-docs. If there's a diff in revision, it means
     * that the documentations that you have locally are out of date.
     *
     * The setup method then downloads the other files.
     */
    setup: () => Promise<void>;
    private loadResource;
    private load;
    private latestRevision;
}
export {};
