"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.memo = exports.filePath = exports.download = exports.root = exports.noop = void 0;
const env_paths_1 = __importDefault(require("env-paths"));
const node_path_1 = __importDefault(require("node:path"));
const themeLiquidDocsDownloader_1 = require("./themeLiquidDocsDownloader");
const noop = () => { };
exports.noop = noop;
const paths = (0, env_paths_1.default)('theme-liquid-docs');
exports.root = paths.cache;
function download(file) {
    return (0, themeLiquidDocsDownloader_1.downloadFile)(file, exports.root);
}
exports.download = download;
function filePath(file) {
    return node_path_1.default.join(exports.root, `${file}.json`);
}
exports.filePath = filePath;
/** Returns a cached version of a function. Only caches one result. */
function memo(fn) {
    let cachedValue;
    return (...args) => {
        if (!cachedValue) {
            cachedValue = fn(...args);
        }
        return cachedValue;
    };
}
exports.memo = memo;
//# sourceMappingURL=utils.js.map