"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileSize = exports.fileExists = void 0;
const promises_1 = __importDefault(require("node:fs/promises"));
async function fileExists(path) {
    try {
        await promises_1.default.stat(path);
        return true;
    }
    catch (e) {
        return false;
    }
}
exports.fileExists = fileExists;
const fileSize = async (path) => {
    try {
        const stats = await promises_1.default.stat(path);
        return stats.size;
    }
    catch (error) {
        console.error(`Failed to get file size: ${error}`);
        return 0;
    }
};
exports.fileSize = fileSize;
//# sourceMappingURL=file-utils.js.map