"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTheme = exports.themeCheckRun = exports.checkAndAutofix = exports.check = exports.toSourceCode = exports.loadConfig = void 0;
const theme_check_common_1 = require("@shopify/theme-check-common");
const node_util_1 = require("node:util");
const node_path_1 = __importDefault(require("node:path"));
const promises_1 = __importDefault(require("node:fs/promises"));
const glob = require("glob");
const theme_check_docs_updater_1 = require("@shopify/theme-check-docs-updater");
const file_utils_1 = require("./file-utils");
const config_1 = require("./config");
Object.defineProperty(exports, "loadConfig", { enumerable: true, get: function () { return config_1.loadConfig; } });
const autofix_1 = require("./autofix");
const defaultLocale = 'en';
const asyncGlob = (0, node_util_1.promisify)(glob);
__exportStar(require("@shopify/theme-check-common"), exports);
__exportStar(require("./config/types"), exports);
async function toSourceCode(absolutePath) {
    try {
        const source = await promises_1.default.readFile(absolutePath, 'utf8');
        return (0, theme_check_common_1.toSourceCode)(absolutePath, source);
    }
    catch (e) {
        return undefined;
    }
}
exports.toSourceCode = toSourceCode;
async function check(root, configPath) {
    const run = await themeCheckRun(root, configPath);
    return run.offenses;
}
exports.check = check;
async function checkAndAutofix(root, configPath) {
    const { theme, offenses } = await themeCheckRun(root, configPath);
    await (0, autofix_1.autofix)(theme, offenses);
}
exports.checkAndAutofix = checkAndAutofix;
async function themeCheckRun(root, configPath) {
    const { theme, config } = await getThemeAndConfig(root, configPath);
    const defaultTranslationsFile = theme.find((sc) => sc.absolutePath.endsWith('default.json'));
    const defaultTranslations = JSON.parse((defaultTranslationsFile === null || defaultTranslationsFile === void 0 ? void 0 : defaultTranslationsFile.source) || '{}');
    const themeLiquidDocsManager = new theme_check_docs_updater_1.ThemeLiquidDocsManager();
    const offenses = await (0, theme_check_common_1.check)(theme, config, {
        fileExists: file_utils_1.fileExists,
        fileSize: file_utils_1.fileSize,
        themeDocset: themeLiquidDocsManager,
        schemaValidators: themeLiquidDocsManager,
        async getDefaultTranslations() {
            return defaultTranslations;
        },
        async getDefaultLocale() {
            var _a;
            if (!defaultTranslationsFile) {
                return defaultLocale;
            }
            const defaultTranslationsFileLocale = (_a = defaultTranslationsFile.absolutePath.match(/locales\/(.*)\.default\.json$/)) === null || _a === void 0 ? void 0 : _a[1];
            return defaultTranslationsFileLocale || defaultLocale;
        },
    });
    return {
        theme,
        config,
        offenses,
    };
}
exports.themeCheckRun = themeCheckRun;
async function getThemeAndConfig(root, configPath) {
    configPath = configPath !== null && configPath !== void 0 ? configPath : (await (0, config_1.findConfigPath)(root));
    const config = await (0, config_1.loadConfig)(configPath, root);
    const theme = await getTheme(config);
    return {
        theme,
        config,
    };
}
async function getTheme(config) {
    const paths = await asyncGlob(node_path_1.default.join(config.root, '**/*.{liquid,json}')).then((result) => 
    // Global ignored paths should not be part of the theme
    result.filter((filePath) => !(0, theme_check_common_1.isIgnored)(filePath, config)));
    const sourceCodes = await Promise.all(paths.map(toSourceCode));
    return sourceCodes.filter((x) => x !== undefined);
}
exports.getTheme = getTheme;
//# sourceMappingURL=index.js.map