"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMockNodeModule = exports.mockNodeModuleCheck = exports.createMockConfigFile = exports.removeTmpFolder = exports.makeTmpFolder = void 0;
const promises_1 = __importDefault(require("node:fs/promises"));
const node_path_1 = __importDefault(require("node:path"));
const node_os_1 = __importDefault(require("node:os"));
async function makeTmpFolder() {
    const tmpDir = await promises_1.default.mkdtemp(node_path_1.default.join(node_os_1.default.tmpdir(), 'test-'));
    await promises_1.default.mkdir(node_path_1.default.join(tmpDir, '.git'));
    return tmpDir;
}
exports.makeTmpFolder = makeTmpFolder;
async function removeTmpFolder(tempDir) {
    return promises_1.default.rm(tempDir, { recursive: true, force: true });
}
exports.removeTmpFolder = removeTmpFolder;
async function createMockConfigFile(tempDir, contents = 'dummy content', relativePath = '.theme-check.yml') {
    const filePath = node_path_1.default.join(tempDir, relativePath);
    await promises_1.default.writeFile(filePath, contents, 'utf8');
    return filePath;
}
exports.createMockConfigFile = createMockConfigFile;
exports.mockNodeModuleCheck = `
  const NodeModuleCheck = {
    meta: {
      name: 'NodeModuleCheck',
      code: 'NodeModuleCheck',
      docs: { description: '...' },
      schema: {},
      severity: 0,
      targets: [],
      type: 'LiquidHtml',
    },
    create() {
      return {};
    },
  };

  exports.checks = [
    NodeModuleCheck,
  ];
`;
async function createMockNodeModule(tempDir, moduleName, moduleContent = exports.mockNodeModuleCheck) {
    const nodeModuleRoot = node_path_1.default.join(tempDir, 'node_modules', ...moduleName.split('/'));
    await promises_1.default.mkdir(nodeModuleRoot, { recursive: true });
    await promises_1.default.writeFile(node_path_1.default.join(nodeModuleRoot, 'package.json'), JSON.stringify({
        name: moduleName,
        main: './index.js',
    }), 'utf8');
    await promises_1.default.writeFile(node_path_1.default.join(nodeModuleRoot, 'index.js'), moduleContent);
    return nodeModuleRoot;
}
exports.createMockNodeModule = createMockNodeModule;
//# sourceMappingURL=test-helpers.js.map