'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('react');
var context = require('../context.js');
var errors = require('../errors.js');

/**
 * Returns the full API object that was passed in to your
 * extension when it was created.
 */
function useApi(_target) {
  const api = react.useContext(context.ExtensionApiContext);
  if (api == null) {
    throw new errors.AdminUIExtensionError('No extension api found.');
  }
  return api;
}

/**
 * Returns the full API object that was passed in to your
 * extension when it was created.
 * @deprecated you shoud be importing useApi instead
 */
function useExtensionApi() {
  return useApi();
}

exports.useApi = useApi;
exports.useExtensionApi = useExtensionApi;
