'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var react = require('@remote-ui/react');
var admin = require('@shopify/ui-extensions/admin');
var context = require('./context.js');
var jsxRuntime = require('react/jsx-runtime');

function reactExtension(target, render) {
  // TypeScript can’t infer the type of the callback because it’s a big union
  // type. To get around it, we’ll just fake like we are rendering the
  // Playground extension, since all render extensions have the same general
  // shape (`RenderExtension`).
  return admin.extension(target, async (root, api) => {
    const element = await render(api);
    await new Promise((resolve, reject) => {
      try {
        react.render( /*#__PURE__*/jsxRuntime.jsx(context.ExtensionApiContext.Provider, {
          value: api,
          children: element
        }), root, () => {
          resolve();
        });
      } catch (error) {
        // Workaround for https://github.com/Shopify/ui-extensions/issues/325
        // eslint-disable-next-line no-console
        console.error(error);
        reject(error);
      }
    });
  });
}

exports.reactExtension = reactExtension;
exports.render = reactExtension;
