'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

class CheckoutUIExtensionError extends Error {
  constructor(...args) {
    super(...args);
    this.name = 'CheckoutUIExtensionError';
  }
}
class ScopeNotGrantedError extends Error {
  constructor(...args) {
    super(...args);
    this.name = 'ScopeNotGrantedError';
  }
}
class ExtensionHasNoMethodError extends Error {
  constructor(method, target) {
    super(`Cannot call '${method}()' on target '${target}'. The corresponding property was not found on the API.`);
    this.name = 'ExtensionHasNoMethodError';
  }
}
class ExtensionHasNoTargetError extends Error {
  constructor(method, target) {
    super(`Cannot call '${method}()' on target '${target}'. Property 'target' is not found on api.`);
    this.name = 'ExtensionHasNoTargetError';
  }
}

exports.CheckoutUIExtensionError = CheckoutUIExtensionError;
exports.ExtensionHasNoMethodError = ExtensionHasNoMethodError;
exports.ExtensionHasNoTargetError = ExtensionHasNoTargetError;
exports.ScopeNotGrantedError = ScopeNotGrantedError;
