'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the proposed `attributes` applied to the checkout.
 */
function useAttributes() {
  return subscription.useSubscription(api.useApi().attributes);
}

/**
 * Returns the values for the specified `attributes` applied to the checkout.
 *
 * @param keys - An array of attribute keys.
 */
function useAttributeValues(keys) {
  const attributes = useAttributes();
  if (!(attributes !== null && attributes !== void 0 && attributes.length)) {
    return [];
  }
  return keys.map(key => {
    const attribute = attributes.find(attribute => attribute.key === key);
    return attribute === null || attribute === void 0 ? void 0 : attribute.value;
  });
}

/**
 * Returns a function to mutate the `attributes` property of the checkout.
 */
function useApplyAttributeChange() {
  const api$1 = api.useApi();
  if ('applyAttributeChange' in api$1) {
    return api$1.applyAttributeChange;
  }
  throw new errors.ExtensionHasNoMethodError('applyAttributeChange', api$1.extension.target);
}

exports.useApplyAttributeChange = useApplyAttributeChange;
exports.useAttributeValues = useAttributeValues;
exports.useAttributes = useAttributes;
