'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the proposed `billingAddress` applied to the checkout.
 */
function useBillingAddress() {
  const billingAddress = api.useApi().billingAddress;
  if (!billingAddress) {
    throw new errors.ScopeNotGrantedError('Using billing address requires having billing address permissions granted to your app.');
  }
  return subscription.useSubscription(billingAddress);
}

exports.useBillingAddress = useBillingAddress;
