'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the cart line the extension is attached to. This hook can only be used by extensions in the following
 * extension targets:
 * - `purchase.cart-line-item.line-components.render`
 * - `purchase.checkout.cart-line-item.render-after`
 * - `purchase.thank-you.cart-line-item.render-after`
 * - 'customer-account.order-status.cart-line-item.render-after'
 */
function useCartLineTarget() {
  const api$1 = api.useApi();
  if (!api$1.target) {
    throw new errors.ExtensionHasNoTargetError('useCartLineTarget', api$1.extension.target);
  }
  return subscription.useSubscription(api$1.target);
}

exports.useCartLineTarget = useCartLineTarget;
