'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var errors = require('../errors.js');
var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * Returns the current line items for the checkout, and automatically re-renders
 * your component if line items are added, removed, or updated.
 */
function useCartLines() {
  const {
    lines
  } = api.useApi();
  return subscription.useSubscription(lines);
}

/**
 * Returns a function to mutate the `lines` property of checkout.
 */
function useApplyCartLinesChange() {
  const api$1 = api.useApi();
  if ('applyCartLinesChange' in api$1) {
    return api$1.applyCartLinesChange;
  }
  throw new errors.ExtensionHasNoMethodError('applyCartLinesChange', api$1.extension.target);
}

exports.useApplyCartLinesChange = useApplyCartLinesChange;
exports.useCartLines = useCartLines;
