'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var api = require('./api.js');
var subscription = require('./subscription.js');

/**
 * A `Money` value representing the subtotal value of the items in the cart at the current
 * step of checkout.
 */
function useSubtotalAmount() {
  return subscription.useSubscription(api.useApi().cost.subtotalAmount);
}

/**
 * A `Money` value representing the total shipping a buyer can expect to pay at the current
 * step of checkout. This value includes shipping discounts. Returns undefined if shipping
 * has not been negotiated yet, such as on the information step.
 */
function useTotalShippingAmount() {
  return subscription.useSubscription(api.useApi().cost.totalShippingAmount);
}

/**
 * A `Money` value representing the total tax a buyer can expect to pay at the current
 * step of checkout or the total tax included in product and shipping prices. Returns
 * undefined if taxes are unavailable.
 */
function useTotalTaxAmount() {
  return subscription.useSubscription(api.useApi().cost.totalTaxAmount);
}

/**
 * Returns a `Money` value representing the minimum a buyer can expect to pay at the current
 * step of checkout. This value excludes amounts yet to be negotiated. For example,
 * the information step might not have delivery costs calculated.
 */
function useTotalAmount() {
  return subscription.useSubscription(api.useApi().cost.totalAmount);
}

exports.useSubtotalAmount = useSubtotalAmount;
exports.useTotalAmount = useTotalAmount;
exports.useTotalShippingAmount = useTotalShippingAmount;
exports.useTotalTaxAmount = useTotalTaxAmount;
